<?php
/* --------------------------------------------------------------
  TransactionResult.php 2015-01-07 nik
  Smart Payment Solutions GmbH
  http://www.smart-payment-solutions.de/
  Copyright (c) 2015 Smart Payment Solutions GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------
 */

/**
 * The result of a create transaction. It is used for further requests.
 */
class Raa_TransactionResult {
	/**
	 * @var string The transaction id generated by the matching server.
	 */
	public $tid;
	/**
	 * @var The server info of the matching server.
	 */
	public $serverInfo;

	public function __construct($tid, $srvInfo) {
		$this->tid = $tid;
		$this->serverInfo = $srvInfo;
	}

	public function __toString() {
		return 'Raa_TransactionResult: {' . $this->tid . ', ' .  $this->serverInfo . '}';
	}
}
